/*
 * Created on Sep 10, 2003
 *
 * To change the template for this generated file go to
 * Window>Preferences>Java>Code Generation>Code and Comments
 */
package DatabaseCommunication;
import java.sql.*;
import JavaBeans.*;
import java.io.*;
import java.util.*;
/**
 * @author student
 *
 * This class is being used for communication with the application Database
 * with information relevant to Customers.
 * 
 */
public class CustomerManager {
	private Connection con;
	

	/**
	 * This is the constructor for CustomerManager.java
	 */
	public CustomerManager(){
		try{
			//get the url from the coffee configuration file
			//currently resident in C:\jboss\bin.
			Properties p = new Properties ();
			p.load(new FileInputStream("coffee.txt"));		
			String url = p.getProperty("MYSQLURL");
			
			//initiate connection.
			Class.forName("com.mysql.jdbc.Driver").newInstance();	
			con = DriverManager.getConnection(url,"root", "password");
			System.out.println("Now connected to the Coffee database from User manager.");
		}catch(Exception e){
			System.out.println("Customer Manager constructor exception : "+e.toString());
	
		}

	}
	
	
	
	/**
	 * This method is being used for inserting new Customers into the application
	 * database.
	 * @param customer The customer that is to added to the application database.
	 * @return boolean Specifies whether the adding of customer was successful.
	 */
	public boolean insertCustomer(Customer_Data customer){
		String preBill = customer.getPreBillingAmount();
		String acc = String.valueOf(customer.getAccount());
		String insert ="INSERT INTO customer (UserName, PreBillingAmount, Account)"
		+ " VALUES"
		+ "('"+customer.getUserName()+"', "+preBill+", "+acc+" );";
		try{
			Statement stmt = con.createStatement();
			stmt.executeUpdate(insert);
			insertCoffeePreference(customer);			
		}catch(Exception e){
			System.out.println("Error in Customer manager insertCustomer :"+e.toString());
			return false;
		}
		return true;
	}
	
	/**
	 * This method is being used for inserting the coffee preference that a
	 * customer has.
	 * @param customer The customer whose coffee preference is to added to the
	 * application database.
	 * @return boolean Specifies whether the adding of the coffee preference was
	 * successful.
	 */
	private boolean insertCoffeePreference(Customer_Data customer){
		CoffeePreference_Data pref = customer.getPreference();
		try{
			Statement stmt = con.createStatement();
			String insert ="INSERT INTO coffeepreference (UserName, ItemCode, Quantity, DeliveryHour, DeliveryMinute)"
			+ " VALUES"
			+ "('"+customer.getUserName()+"', '"
			+pref.getItemCode()+"', "
			+pref.getQuantity()+", '"
			+pref.getDeliveryHour()+"', '"
			+pref.getDeliveryMinute()+"' );";
			
			stmt.executeUpdate(insert);
		
			stmt.close();
		}catch(Exception e){
			System.out.println("Error in CustomerManager insertPreference :"+e.toString());
			return false;
		}
		return true;
	}
	
	/**
	 * This method is being used for reading particular customer details
	 * given a Customer_Data with a matching username.
	 * @param customer The customer whose details are to be retrieved from the
	 * application database.
	 * @return boolean Specifies whether reading the customer details was
	 * successful.
	 */
	public boolean readCustomer(Customer_Data customer){
		try{
			Statement stmt = con.createStatement();
			String query = "SELECT * FROM customer WHERE UserName='"+customer.getUserName()+"';";
			ResultSet rs = stmt.executeQuery(query);
			boolean isFilled = rs.next();
			
			if(!isFilled){
				System.out.println("isFilled is false..");
				return false;
			}
		
			customer.setPreBillingAmount(rs.getString(2));
			customer.setAccount(Double.valueOf(rs.getString(3)).doubleValue());
			readCoffeePreference(customer);
			stmt.close();
			return true;
		}catch(Exception e){
			System.out.println("Error in Customer manager readCustomer :"+e.toString());
			return false;
		}
	}

	/**
	 * This method is being used for reading particular coffeepreference
	 * details given a customer.
	 * @param customer The customer whose coffee preference is to be retrieved.
	 * @return boolean Specifies whether reading the coffee preference was
	 * successful.
	 */
	private boolean readCoffeePreference(Customer_Data customer){
		CoffeePreference_Data pref = customer.getPreference();
		try{
						
			if(pref==null){
				pref = new CoffeePreference_Data();
			}
			
			Statement s = con.createStatement();
		
			String qry = "SELECT * FROM coffeepreference WHERE UserName='"+customer.getUserName()+"';";
			System.out.println("String : "+qry);
		
			ResultSet rs = s.executeQuery(qry);
			rs.next();
			pref.setItemCode(rs.getString(3));
			pref.setQuantity(rs.getString(4));
			pref.setDeliveryHour(rs.getString(5));
			pref.setDeliveryMinute(rs.getString(6));
			
			System.out.println("rs code : "+rs.getString(3));
			System.out.println("rs quantity : "+rs.getString(4));
			System.out.println("rs deliverHour : "+rs.getString(5));
			System.out.println("rs deliveryMinute : "+rs.getString(6));
			rs.close();
		
			customer.setPreference(pref);
			s.close();
			
			return true;
		}catch(Exception e){
			System.out.println("Error in Customer manager readPreference :"+e.toString());
			return false;
		}
	}
	
	/**
	 * This method is being used for updating the given customer's account
	 * balances.
	 * @param customer The customer whose account details are to be updated.
	 * @return boolean Specifies whether the customer update was successful.
	 */
	public boolean updateCustomer(Customer_Data customer){
		String acc = String.valueOf(customer.getAccount());
		String pre = customer.getPreBillingAmount();
		String update ="UPDATE customer SET "
		+"Account="+customer.getAccount()+" ,"
		+"PreBillingAmount='"+pre+"' "
		+"WHERE UserName='"+customer.getUserName()+"';";
		try{
			Statement stmt = con.createStatement();
			stmt.executeUpdate(update);
						
		}catch(Exception e){
			System.out.println("Error in Customer manager updateCustomer :"+e.toString());
			return false;
		}
		return true;
	}
	
	/**
	 * This method is being used for updating the coffee preference for
	 * a particular customer.
	 * @param customer The customer whose coffee preference is to be updated.
	 * @return boolean Specifies whether the update was successful.
	 */
	public boolean updateCoffeePreference(Customer_Data customer){
		CoffeePreference_Data pref = customer.getPreference();
		try{
			Statement stmt = con.createStatement();
			String update = "UPDATE coffeepreference SET "+
			"ItemCode='"+pref.getItemCode()+"', "+
			"Quantity='"+pref.getQuantity()+"', "+
			"DeliveryHour='"+pref.getDeliveryHour()+"', "+
			"DeliveryMinute='"+pref.getDeliveryMinute()+"' "+
			"WHERE UserName='"+customer.getUserName()+"'";
			
			stmt.executeUpdate(update);
			
			stmt.close();
		}catch(Exception e){
			System.out.println("Error in Customer manager updateCoffeePreference :"+e.toString());
			return false;
		}
		return true;
	}
		
}
